struct VS_INPUT_SOLID
{
	float4 Position   : POSITION;
	int4   BatchIndex : BLENDINDICES;
};

struct VS_INPUT_ALPHA
{
	float4 Position   : POSITION;
	int4   BatchIndex : BLENDINDICES;
	half2  TexCoord	  : TEXCOORD0;
};

#ifndef MAX_BATCH_SIZE
	#define MAX_BATCH_SIZE 32
#endif

row_major float4x4 arrWorldTx[MAX_BATCH_SIZE] : register(c[0]);
float4 arrMatAlpha[MAX_BATCH_SIZE] : register(c[MAX_BATCH_SIZE*4]);

float4x4 ViewProj;

sampler2D Tex0 : register( s0 );

void vs_Opaque( 
	in VS_INPUT_SOLID In,
	out float4 Position : POSITION) 
{
	// Opaque uses larger batches, thus BatchIndex.y component is needed
	Position = mul( mul( In.Position, arrWorldTx[In.BatchIndex.y] ), ViewProj );
}

float4 ps_Opaque() : COLOR
{
    return 1;
}

void vs_Alpha( 
	in VS_INPUT_ALPHA In,
	out float2 TexCoord : TEXCOORD0,
	out float Alpha 	: TEXCOORD1,
	out float4 Position : POSITION)
{
	TexCoord = In.TexCoord;
	// Alpha uses standard batches, thus BatchIndex.x component is needed
	Alpha = arrMatAlpha[In.BatchIndex.x].x;
	Position = mul( mul( In.Position, arrWorldTx[In.BatchIndex.x] ), ViewProj );
}

float4 ps_Alpha(
	float2 TexCoord : TEXCOORD0,
	float  Alpha 	: TEXCOORD1) : COLOR
{
	if(Alpha < 0.75) 
		clip(-1);
	else
		clip( tex2D(Tex0, TexCoord).a * Alpha - 0.75f );
	return 1;
}

technique ShadowMap
{
	pass Opaque
	{
		VertexShader = compile vs_3_0 vs_Opaque();
		PixelShader = compile ps_3_0 ps_Opaque();
	}
	pass Alpha
	{
		VertexShader = compile vs_3_0 vs_Alpha();
		PixelShader = compile ps_3_0 ps_Alpha();
	}
}
